import { ActionState, Shard } from '../../../api';
import { DownloadStrategy, DownloadParams } from './strategy';
import { DownloadOptions } from '.';
export interface DownloadOneShardStrategyParams extends DownloadParams {
    useProxy: boolean;
    chunkSize?: number;
}
export type DownloadOneShardStrategyLabel = 'OneShardOnly';
export type DownloadOneShardStrategyObject = {
    label: DownloadOneShardStrategyLabel;
    params: DownloadOneShardStrategyParams;
};
export type DownloadOneShardStrategyFunction = (bucketId: string, fileId: string, opts: DownloadOptions, strategyObj: DownloadOneShardStrategyObject) => ActionState;
export declare class DownloadOneShardStrategy extends DownloadStrategy {
    private abortables;
    private downloadProgress;
    private decipher;
    private useProxy;
    private progressIntervalId;
    private aborted;
    constructor(params: DownloadOneShardStrategyParams);
    private startProgressInterval;
    private stopProgressInterval;
    private addAbortable;
    download(mirrors: Shard[]): Promise<void>;
    private cleanup;
    private handleError;
    abort(): void;
}
