import { ActionState, Shard } from '../../../api';
import { DownloadStrategy } from './strategy';
import { DownloadOneShardStrategy, DownloadOneShardStrategyParams, DownloadOneStreamStrategy, DownloadOneStreamStrategyParams, DownloadOptions } from '.';
export type DownloadDynamicStrategyLabel = 'Dynamic';
export type DownloadDynamicStrategyObject<T> = {
    label: DownloadDynamicStrategyLabel;
    params: T extends DownloadOneShardStrategy ? DownloadOneShardStrategyParams : DownloadOneStreamStrategyParams;
};
export type DownloadDynamicStrategyFunction<T> = (bucketId: string, fileId: string, opts: DownloadOptions, strategyObj: DownloadDynamicStrategyObject<T>) => ActionState;
export declare class DownloadDynamicStrategy<T = DownloadOneShardStrategy | DownloadOneStreamStrategy> extends DownloadStrategy {
    private strategy?;
    private params;
    iv: Buffer<ArrayBuffer>;
    fk: Buffer<ArrayBuffer>;
    constructor(params: T extends DownloadOneShardStrategy ? DownloadOneShardStrategyParams : DownloadOneStreamStrategyParams);
    download(mirrors: Shard[]): Promise<void>;
    setIv(iv: Buffer): void;
    setFileEncryptionKey(fk: Buffer): void;
    abort(): void;
}
