"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.downloadFileV2 = downloadFileV2;
var crypto_1 = require("crypto");
var stream_1 = require("stream");
var promises_1 = require("stream/promises");
var bip39_1 = require("bip39");
var network_1 = require("@internxt/sdk/dist/network");
var download_1 = require("@internxt/sdk/dist/network/download");
var request_1 = require("../../../services/request");
var crypto_2 = require("../../utils/crypto");
var streams_1 = require("../../utils/streams");
var errors_1 = __importDefault(require("./errors"));
var Chunker_1 = require("../../utils/streams/Chunker");
function downloadFileV2(fileId, bucketId, mnemonic, bridgeUrl, creds, appDetails, notifyProgress, onV2Confirmed, abortController, chunkSize) {
    var _this = this;
    var outStream = new stream_1.PassThrough();
    var network = network_1.Network.client(bridgeUrl, __assign(__assign({}, appDetails), { customHeaders: __assign({ lib: 'inxt-js' }, appDetails.customHeaders) }), {
        bridgeUser: creds.user,
        userId: (0, crypto_2.sha256)(Buffer.from(creds.pass)).toString('hex')
    });
    var fileEncryptedSlices = [];
    var downloadFileStep = function (downloadables) { return __awaiter(_this, void 0, void 0, function () {
        var _i, _a, downloadable, _b, _c;
        var _d;
        return __generator(this, function (_e) {
            switch (_e.label) {
                case 0:
                    onV2Confirmed();
                    _i = 0, _a = downloadables.sort(function (dA, dB) { return dA.index - dB.index; });
                    _e.label = 1;
                case 1:
                    if (!(_i < _a.length)) return [3 /*break*/, 4];
                    downloadable = _a[_i];
                    _c = (_b = fileEncryptedSlices).push;
                    _d = {
                        hash: downloadable.hash
                    };
                    return [4 /*yield*/, (0, request_1.getStream)(downloadable.url)];
                case 2:
                    _c.apply(_b, [(_d.stream = _e.sent(),
                            _d)]);
                    _e.label = 3;
                case 3:
                    _i++;
                    return [3 /*break*/, 1];
                case 4: return [2 /*return*/];
            }
        });
    }); };
    var decryptFileStep = function (algorithm, key, iv, fileSize) { return __awaiter(_this, void 0, void 0, function () {
        var decipher, progress, _i, fileEncryptedSlices_1, fileEncryptedSlice, hasher, chunker, calculatedHash, expectedHash;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (algorithm !== network_1.ALGORITHMS.AES256CTR.type) {
                        throw errors_1.default.downloadUnknownAlgorithmError;
                    }
                    decipher = (0, crypto_1.createDecipheriv)('aes-256-ctr', key, iv);
                    progress = new streams_1.ProgressNotifier(fileSize, 2000, { emitClose: false });
                    progress.on(streams_1.Events.Progress, function (progress) {
                        notifyProgress(progress, null, null);
                    });
                    _i = 0, fileEncryptedSlices_1 = fileEncryptedSlices;
                    _a.label = 1;
                case 1:
                    if (!(_i < fileEncryptedSlices_1.length)) return [3 /*break*/, 7];
                    fileEncryptedSlice = fileEncryptedSlices_1[_i];
                    hasher = new streams_1.HashStream();
                    if (!chunkSize) return [3 /*break*/, 3];
                    chunker = new Chunker_1.ChunkSizeTransform(chunkSize);
                    return [4 /*yield*/, (0, promises_1.pipeline)(fileEncryptedSlice.stream, hasher, decipher, progress, chunker, outStream, {
                            signal: abortController.signal
                        })];
                case 2:
                    _a.sent();
                    return [3 /*break*/, 5];
                case 3: return [4 /*yield*/, (0, promises_1.pipeline)(fileEncryptedSlice.stream, hasher, decipher, progress, outStream, {
                        signal: abortController.signal
                    })];
                case 4:
                    _a.sent();
                    _a.label = 5;
                case 5:
                    calculatedHash = hasher.getHash().toString('hex');
                    expectedHash = fileEncryptedSlice.hash;
                    if (calculatedHash !== expectedHash) {
                        throw errors_1.default.downloadHashMismatchError;
                    }
                    _a.label = 6;
                case 6:
                    _i++;
                    return [3 /*break*/, 1];
                case 7: return [4 /*yield*/, new Promise(function (res) { return progress.end(res); })];
                case 8:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    }); };
    var downloadPromise = (0, download_1.downloadFile)(fileId, bucketId, mnemonic, network, {
        validateMnemonic: function (mnemonic) {
            return (0, bip39_1.validateMnemonic)(mnemonic);
        },
        algorithm: network_1.ALGORITHMS.AES256CTR,
        randomBytes: crypto_1.randomBytes,
        generateFileKey: function (mnemonic, bucketId, index) {
            return (0, crypto_2.GenerateFileKey)(mnemonic, bucketId, index);
        }
    }, Buffer.from, downloadFileStep, decryptFileStep).catch(function (err) {
        if (err instanceof download_1.FileVersionOneError) {
            throw err;
        }
        outStream.emit('error', err);
    });
    return [downloadPromise, outStream];
}
