"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Environment = void 0;
var lib_1 = require("@internxt/lib");
var core_1 = require("./lib/core");
var crypto_1 = require("./lib/utils/crypto");
// TODO: Remove this
var constants_1 = require("./api/constants");
var api_1 = require("./api");
var fileinfo_1 = require("./api/fileinfo");
var api_2 = require("./services/api");
var streams_1 = require("./lib/utils/streams");
var downloadV2_1 = require("./lib/core/download/downloadV2");
var download_1 = require("@internxt/sdk/dist/network/download");
var uploadV2_1 = require("./lib/core/upload/uploadV2");
var utils = {
    generateFileKey: crypto_1.GenerateFileKey,
    Hasher: streams_1.HashStream,
};
var Environment = /** @class */ (function () {
    function Environment(config) {
        var _this = this;
        this.upload = function (bucketId, opts) {
            var uploadState = new api_1.ActionState(api_1.ActionTypes.Upload);
            if (!_this.config.encryptionKey) {
                opts.finishedCallback(Error('Mnemonic was not provided, please, provide a mnemonic'), null);
                return uploadState;
            }
            if (!_this.config.bridgeUrl) {
                opts.finishedCallback(Error('Missing param "bridgeUrl"'), null);
                return uploadState;
            }
            if (!bucketId) {
                opts.finishedCallback(Error('Bucket id was not provided'), null);
                return uploadState;
            }
            (0, uploadV2_1.uploadFileV2)(opts.fileSize, opts.source, bucketId, _this.config.encryptionKey, _this.config.bridgeUrl, {
                user: _this.config.bridgeUser,
                pass: _this.config.bridgePass
            }, _this.config.appDetails, opts.progressCallback, uploadState).then(function (fileId) {
                opts.finishedCallback(null, fileId);
            }).catch(function (err) {
                opts.finishedCallback(err.message === 'The operation was aborted' ?
                    new Error('Process killed by user') :
                    err, null);
            });
            return uploadState;
        };
        this.download = function (bucketId, fileId, opts, strategyObj) {
            var abortController = new AbortController();
            var downloadState = new api_1.ActionState(api_1.ActionTypes.Download);
            downloadState.once(core_1.Events.Download.Abort, function () {
                abortController.abort();
            });
            if (!_this.config.encryptionKey) {
                opts.finishedCallback(Error(constants_1.ENCRYPTION_KEY_NOT_PROVIDED), null);
                return downloadState;
            }
            if (!bucketId) {
                opts.finishedCallback(Error(constants_1.BUCKET_ID_NOT_PROVIDED), null);
                return downloadState;
            }
            if (!fileId) {
                opts.finishedCallback(Error('File id not provided'), null);
                return downloadState;
            }
            if (!_this.config.bridgeUrl) {
                opts.finishedCallback(Error('Missing bridge url'), null);
                return downloadState;
            }
            var _a = (0, downloadV2_1.downloadFileV2)(fileId, bucketId, _this.config.encryptionKey, _this.config.bridgeUrl, {
                user: _this.config.bridgeUser,
                pass: _this.config.bridgePass
            }, _this.config.appDetails, opts.progressCallback, function () {
                opts.finishedCallback(null, stream);
            }, abortController, strategyObj.params.chunkSize), downloadPromise = _a[0], stream = _a[1];
            downloadPromise.catch(function (err) {
                if (err instanceof download_1.FileVersionOneError) {
                    var strategy = null;
                    if (strategyObj.label === 'Dynamic') {
                        strategy = new core_1.DownloadDynamicStrategy(strategyObj.params);
                    }
                    if (!strategy) {
                        opts.finishedCallback(Error('Unknown strategy'), null);
                        return downloadState;
                    }
                    (0, core_1.download)(_this.config, bucketId, fileId, opts, downloadState, strategy)
                        .then(function (res) {
                        opts.finishedCallback(null, res);
                    })
                        .catch(function (downloadErr) {
                        opts.finishedCallback(downloadErr, null);
                    });
                }
                else {
                    opts.finishedCallback(err, null);
                }
            });
            return downloadState;
        };
        this.config = config;
    }
    /**
     * Gets file info
     * @param bucketId Bucket id where file is stored
     * @param fileId
     * @returns file info
     */
    Environment.prototype.getFileInfo = function (bucketId, fileId) {
        return (0, fileinfo_1.GetFileInfo)(this.config, bucketId, fileId);
    };
    /**
     * Gets list of available buckets
     * @param cb Callback that will receive the list of buckets
     */
    Environment.prototype.getBuckets = function (cb) {
        /* TODO */
        cb(Error('Not implemented yet'), null);
    };
    /**
     * Gets a bucket id by name
     * @param bucketName Name of the bucket to be retrieved
     * @param cb Callback that will receive the bucket id
     */
    Environment.prototype.getBucketId = function (bucketName, cb) {
        /* TODO */
        cb(Error('Not implemented yet'), null);
    };
    /**
     * Creates a bucket
     * @param bucketName Name of the new bucket
     * @returns Bucket id
     */
    Environment.prototype.createBucket = function (bucketName) {
        return new api_2.Bridge(this.config)
            .createBucket(bucketName)
            .start()
            .then(function (bucket) {
            return bucket.id;
        })
            .catch(function (err) {
            throw new Error(lib_1.request.extractMessageFromError(err));
        });
    };
    /**
     * Creates file token
     * @param bucketId Bucket id where file is stored
     * @param fileId File id
     * @param operation
     * @param cb
     */
    Environment.prototype.createFileToken = function (bucketId, fileId, operation) {
        return new api_2.Bridge(this.config)
            .createFileToken(bucketId, fileId, operation)
            .start()
            .then(function (res) {
            return res.token;
        });
    };
    /**
     * Deletes a bucket
     * @param bucketId Id whose bucket is going to be deleted
     * @param cb Callback that will receive the response after deletion
     */
    Environment.prototype.deleteBucket = function (bucketId) {
        return new api_2.Bridge(this.config)
            .deleteBucket(bucketId)
            .start()
            .catch(function (err) {
            throw new Error(lib_1.request.extractMessageFromError(err));
        });
    };
    /**
     * Deletes a file from a bucket
     * @param bucketId Bucket id where file is
     * @param fileId Id of the file to be deleted
     * @param cb Callback that receives the response after deletion
     */
    Environment.prototype.deleteFile = function (bucketId, fileId, cb) {
        /* TODO */
        cb(Error('Not implemented yet'), null);
    };
    /**
     * Lists files in a bucket
     * @param bucketId Bucket id whose files are going to be listed
     * @param cb Callback that receives the files list
     */
    Environment.prototype.listFiles = function (bucketId, cb) {
        /* TODO */
        cb(Error('Not implemented yet'), null);
    };
    Environment.prototype.setEncryptionKey = function (newEncryptionKey) {
        this.config.encryptionKey = newEncryptionKey;
    };
    Environment.prototype.uploadMultipartFile = function (bucketId, opts) {
        var uploadState = new api_1.ActionState(api_1.ActionTypes.Upload);
        if (!this.config.encryptionKey) {
            opts.finishedCallback(Error('Mnemonic was not provided, please, provide a mnemonic'), null);
            return uploadState;
        }
        if (!this.config.bridgeUrl) {
            opts.finishedCallback(Error('Missing param "bridgeUrl"'), null);
            return uploadState;
        }
        if (!bucketId) {
            opts.finishedCallback(Error('Bucket id was not provided'), null);
            return uploadState;
        }
        // if (!opts.parts || isNaN(opts.parts) || opts.parts < 2) {
        //   opts.finishedCallback(Error('Invalid "parts" parameter. Expected number > 1'), null);
        //   return uploadState;
        // }
        (0, uploadV2_1.uploadFileMultipart)(opts.fileSize, opts.source, bucketId, this.config.encryptionKey, this.config.bridgeUrl, {
            user: this.config.bridgeUser,
            pass: this.config.bridgePass
        }, opts.progressCallback, uploadState, this.config.appDetails).then(function (fileId) {
            opts.finishedCallback(null, fileId);
        }).catch(function (err) {
            opts.finishedCallback(err.message === 'The operation was aborted' ?
                new Error('Process killed by user') :
                err, null);
        });
        return uploadState;
    };
    Environment.prototype.downloadCancel = function (state) {
        state.stop();
    };
    Environment.prototype.uploadCancel = function (state) {
        state.stop();
    };
    Environment.prototype.renameFile = function (bucketId, fileId, newPlainName) {
        var _this = this;
        var mnemonic = this.config.encryptionKey;
        if (!mnemonic) {
            throw new Error(constants_1.ENCRYPTION_KEY_NOT_PROVIDED);
        }
        return (0, crypto_1.EncryptFilename)(mnemonic, bucketId, newPlainName).then(function (newEncryptedName) {
            return new api_2.Bridge(_this.config).renameFile(bucketId, fileId, newEncryptedName).start();
        });
    };
    Environment.prototype.getDownloadLinks = function (bucketId, fileIds) {
        return new api_2.Bridge(this.config).getDownloadLinks(bucketId, fileIds).start();
    };
    Environment.utils = utils;
    return Environment;
}());
exports.Environment = Environment;
