import { UploadStrategyFunction, UploadOptions, DownloadStrategyFunction } from './lib/core';
import { GenerateFileKey } from './lib/utils/crypto';
import { ActionState, EnvironmentConfig } from './api';
import { FileInfo } from './api/fileinfo';
import { GetDownloadLinksResponse } from './services/api';
import { HashStream } from './lib/utils/streams';
type GetBucketsCallback = (err: Error | null, result: any) => void;
type GetBucketIdCallback = (err: Error | null, result: any) => void;
type ListFilesCallback = (err: Error | null, result: any) => void;
type DeleteFileCallback = (err: Error | null, result: any) => void;
export declare class Environment {
    config: EnvironmentConfig;
    static utils: {
        generateFileKey: typeof GenerateFileKey;
        Hasher: typeof HashStream;
    };
    constructor(config: EnvironmentConfig);
    /**
     * Gets file info
     * @param bucketId Bucket id where file is stored
     * @param fileId
     * @returns file info
     */
    getFileInfo(bucketId: string, fileId: string): Promise<FileInfo>;
    /**
     * Gets list of available buckets
     * @param cb Callback that will receive the list of buckets
     */
    getBuckets(cb: GetBucketsCallback): void;
    /**
     * Gets a bucket id by name
     * @param bucketName Name of the bucket to be retrieved
     * @param cb Callback that will receive the bucket id
     */
    getBucketId(bucketName: string, cb: GetBucketIdCallback): void;
    /**
     * Creates a bucket
     * @param bucketName Name of the new bucket
     * @returns Bucket id
     */
    createBucket(bucketName: string): Promise<string>;
    /**
     * Creates file token
     * @param bucketId Bucket id where file is stored
     * @param fileId File id
     * @param operation
     * @param cb
     */
    createFileToken(bucketId: string, fileId: string, operation: 'PUSH' | 'PULL'): Promise<string>;
    /**
     * Deletes a bucket
     * @param bucketId Id whose bucket is going to be deleted
     * @param cb Callback that will receive the response after deletion
     */
    deleteBucket(bucketId: string): Promise<void>;
    /**
     * Deletes a file from a bucket
     * @param bucketId Bucket id where file is
     * @param fileId Id of the file to be deleted
     * @param cb Callback that receives the response after deletion
     */
    deleteFile(bucketId: string, fileId: string, cb: DeleteFileCallback): void;
    /**
     * Lists files in a bucket
     * @param bucketId Bucket id whose files are going to be listed
     * @param cb Callback that receives the files list
     */
    listFiles(bucketId: string, cb: ListFilesCallback): void;
    setEncryptionKey(newEncryptionKey: string): void;
    uploadMultipartFile(bucketId: string, opts: UploadOptions): ActionState;
    upload: UploadStrategyFunction;
    download: DownloadStrategyFunction<any>;
    downloadCancel(state: ActionState): void;
    uploadCancel(state: ActionState): void;
    renameFile(bucketId: string, fileId: string, newPlainName: string): Promise<void>;
    getDownloadLinks(bucketId: string, fileIds: string[]): Promise<GetDownloadLinksResponse>;
}
export {};
