import { Express } from 'express';
import { ConfigService } from '../services/config.service';
import { DriveFolderService } from '../services/drive/drive-folder.service';
import { DriveFileService } from '../services/drive/drive-file.service';
import { DownloadService } from '../services/network/download.service';
import { AuthService } from '../services/auth.service';
import { CryptoService } from '../services/crypto.service';
import { TrashService } from '../services/drive/trash.service';
export declare class WebDavServer {
    private readonly app;
    private readonly configService;
    private readonly driveFileService;
    private readonly driveFolderService;
    private readonly downloadService;
    private readonly authService;
    private readonly cryptoService;
    private readonly trashService;
    constructor(app: Express, configService: ConfigService, driveFileService: DriveFileService, driveFolderService: DriveFolderService, downloadService: DownloadService, authService: AuthService, cryptoService: CryptoService, trashService: TrashService);
    private readonly getNetworkFacade;
    private readonly registerStartMiddlewares;
    private readonly registerEndMiddleWares;
    private readonly registerHandlers;
    start: () => Promise<void>;
}
