"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequestLoggerMiddleware = void 0;
const logger_utils_1 = require("../../utils/logger.utils");
const RequestLoggerMiddleware = (config) => {
    return (req, _, next) => {
        if (!config.enable)
            return next();
        if (config.methods && !config.methods.includes(req.method))
            return next();
        logger_utils_1.webdavLogger.info('WebDav request received\n' +
            `Method: ${req.method}\n` +
            `URL: ${req.url}\n` +
            `Body: ${JSON.stringify(req.body)}\n` +
            `Headers: ${JSON.stringify(req.headers)}`);
        next();
    };
};
exports.RequestLoggerMiddleware = RequestLoggerMiddleware;
