"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ErrorHandlingMiddleware = void 0;
const logger_utils_1 = require("../../utils/logger.utils");
const xml_utils_1 = require("../../utils/xml.utils");
const errors_utils_1 = require("../../utils/errors.utils");
const ErrorHandlingMiddleware = (err, req, res, _) => {
    const message = (0, errors_utils_1.isError)(err) ? err.message : 'Something went wrong';
    if ((0, errors_utils_1.isError)(err) && err.stack) {
        logger_utils_1.webdavLogger.error(`[ERROR MIDDLEWARE] [${req.method.toUpperCase()} - ${req.url}] ${message}\nStack: ${err.stack}`);
    }
    else {
        logger_utils_1.webdavLogger.error(`[ERROR MIDDLEWARE] [${req.method.toUpperCase()} - ${req.url}] ${message}`);
    }
    const errorBodyXML = xml_utils_1.XMLUtils.toWebDavXML({
        [xml_utils_1.XMLUtils.addDefaultNamespace('responsedescription')]: message,
    }, {}, 'error');
    let statusCode = 500;
    if ('statusCode' in err && !isNaN(err.statusCode)) {
        statusCode = err.statusCode;
    }
    res.status(statusCode).send(errorBodyXML);
};
exports.ErrorHandlingMiddleware = ErrorHandlingMiddleware;
