"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthMiddleware = void 0;
const sdk_manager_service_1 = require("../../services/sdk-manager.service");
const logger_utils_1 = require("../../utils/logger.utils");
const xml_utils_1 = require("../../utils/xml.utils");
const errors_utils_1 = require("../../utils/errors.utils");
const AuthMiddleware = (authService) => {
    return (_, res, next) => {
        (async () => {
            try {
                const { token } = await authService.getAuthDetails();
                sdk_manager_service_1.SdkManager.init({ token });
                next();
            }
            catch (error) {
                let message = 'Authentication required to access this resource.';
                if ((0, errors_utils_1.isError)(error)) {
                    message = error.message;
                    if (error.stack) {
                        logger_utils_1.webdavLogger.error(`Error from AuthMiddleware: ${message}\nStack: ${error.stack}`);
                    }
                    else {
                        logger_utils_1.webdavLogger.error(`Error from AuthMiddleware: ${message}`);
                    }
                }
                const errorBodyXML = xml_utils_1.XMLUtils.toWebDavXML({
                    [xml_utils_1.XMLUtils.addDefaultNamespace('responsedescription')]: message,
                }, {}, 'error');
                res.status(401).send(errorBodyXML);
            }
        })();
    };
};
exports.AuthMiddleware = AuthMiddleware;
