import { Request, Response } from 'express';
import { DriveFileService } from '../../services/drive/drive-file.service';
import { NetworkFacade } from '../../services/network/network-facade.service';
import { AuthService } from '../../services/auth.service';
import { WebDavMethodHandler } from '../../types/webdav.types';
import { TrashService } from '../../services/drive/trash.service';
import { WebDavFolderService } from '../services/webdav-folder.service';
import { DriveFolderService } from '../../services/drive/drive-folder.service';
export declare class PUTRequestHandler implements WebDavMethodHandler {
    private readonly dependencies;
    constructor(dependencies: {
        driveFileService: DriveFileService;
        driveFolderService: DriveFolderService;
        webDavFolderService: WebDavFolderService;
        trashService: TrashService;
        authService: AuthService;
        networkFacade: NetworkFacade;
    });
    handle: (req: Request, res: Response) => Promise<void>;
}
