"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OPTIONSRequestHandler = void 0;
const webdav_utils_1 = require("../../utils/webdav.utils");
const logger_utils_1 = require("../../utils/logger.utils");
class OPTIONSRequestHandler {
    handle = async (req, res) => {
        const resource = await webdav_utils_1.WebDavUtils.getRequestedResource(req.url);
        logger_utils_1.webdavLogger.info(`[OPTIONS] Request received for item at ${resource.url}`);
        if (resource.url === '/' || resource.url === '') {
            const allowedMethods = 'DELETE, GET, HEAD, MKCOL, MOVE, OPTIONS, PROPFIND, PUT';
            logger_utils_1.webdavLogger.info(`[OPTIONS] Returning Allowed Options: ${allowedMethods}`);
            res.header('Allow', 'DELETE, GET, HEAD, MKCOL, MOVE, OPTIONS, PROPFIND, PUT');
            res.header('DAV', '1, 2, ordered-collections');
            res.status(200).send();
        }
        else if (resource.url.endsWith('/')) {
            const allowedMethods = 'DELETE, HEAD, MKCOL, MOVE, OPTIONS, PROPFIND';
            logger_utils_1.webdavLogger.info(`[OPTIONS] Returning Allowed Options: ${allowedMethods}`);
            res.header('Allow', allowedMethods);
            res.header('DAV', '1, 2, ordered-collections');
            res.status(200).send();
        }
        else {
            const allowedMethods = 'DELETE, GET, HEAD, MOVE, OPTIONS, PROPFIND, PUT';
            logger_utils_1.webdavLogger.info(`[OPTIONS] Returning Allowed Options: ${allowedMethods}`);
            res.header('Allow', allowedMethods);
            res.header('DAV', '1, 2, ordered-collections');
            res.status(200).send();
        }
    };
}
exports.OPTIONSRequestHandler = OPTIONSRequestHandler;
