"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DELETERequestHandler = void 0;
const webdav_utils_1 = require("../../utils/webdav.utils");
const logger_utils_1 = require("../../utils/logger.utils");
const errors_utils_1 = require("../../utils/errors.utils");
class DELETERequestHandler {
    dependencies;
    constructor(dependencies) {
        this.dependencies = dependencies;
    }
    handle = async (req, res) => {
        const { driveFileService, driveFolderService, trashService } = this.dependencies;
        const resource = await webdav_utils_1.WebDavUtils.getRequestedResource(req.url);
        logger_utils_1.webdavLogger.info(`[DELETE] Request received for item at ${resource.url}`);
        const driveItem = await webdav_utils_1.WebDavUtils.getDriveItemFromResource({
            resource,
            driveFolderService,
            driveFileService: driveFileService,
        });
        if (!driveItem) {
            throw new errors_utils_1.NotFoundError(`Resource not found on Internxt Drive at ${resource.url}`);
        }
        logger_utils_1.webdavLogger.info(`[DELETE] [${driveItem.uuid}] Trashing ${driveItem.itemType}`);
        await trashService.trashItems({
            items: [{ type: driveItem.itemType, uuid: driveItem.uuid }],
        });
        res.status(204).send();
        const type = driveItem.itemType.charAt(0).toUpperCase() + driveItem.itemType.substring(1);
        logger_utils_1.webdavLogger.info(`[DELETE] [${driveItem.uuid}] ${type} trashed successfully`);
    };
}
exports.DELETERequestHandler = DELETERequestHandler;
