"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.XMLUtils = void 0;
const fast_xml_parser_1 = require("fast-xml-parser");
class XMLUtils {
    static DEFAULT_NAMESPACE_LETTER = 'D';
    static toJSON(xml, options = {}) {
        const parser = new fast_xml_parser_1.XMLParser(options);
        return parser.parse(xml);
    }
    static toXML(object, options = { format: true }) {
        const builder = new fast_xml_parser_1.XMLBuilder(options);
        return builder.build(object);
    }
    static toWebDavXML(object, options, rootObject = 'multistatus') {
        const xmlContent = this.toXML(object, options);
        return ('<?xml version="1.0" encoding="utf-8" ?>' +
            `<${XMLUtils.addDefaultNamespace(rootObject)} xmlns:${XMLUtils.DEFAULT_NAMESPACE_LETTER}="DAV:">` +
            `${xmlContent}` +
            `</${XMLUtils.addDefaultNamespace(rootObject)}>`);
    }
    static addDefaultNamespace(key) {
        return `${XMLUtils.DEFAULT_NAMESPACE_LETTER}:${key}`;
    }
    static encodeWebDavUri(uri) {
        return encodeURIComponent(uri).replaceAll('%2F', '/');
    }
}
exports.XMLUtils = XMLUtils;
