"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFileStreamWithBuffer = exports.tryUploadThumbnail = exports.isImageThumbnailable = exports.isPDFThumbnailable = exports.isFileThumbnailable = exports.ThumbnailConfig = void 0;
const thumbnail_service_1 = require("../services/thumbnail.service");
const errors_utils_1 = require("./errors.utils");
const stream_utils_1 = require("./stream.utils");
const node_fs_1 = require("node:fs");
exports.ThumbnailConfig = {
    MaxWidth: 300,
    MaxHeight: 300,
    Quality: 100,
    Type: 'png',
};
const imageExtensions = {
    tiff: ['tif', 'tiff'],
    bmp: ['bmp'],
    heic: ['heic'],
    jpg: ['jpg', 'jpeg'],
    gif: ['gif'],
    png: ['png'],
    eps: ['eps'],
    raw: ['raw', 'cr2', 'nef', 'orf', 'sr2'],
    webp: ['webp'],
};
const pdfExtensions = {
    pdf: ['pdf'],
};
const thumbnailableImageExtension = [
    ...imageExtensions['jpg'],
    ...imageExtensions['png'],
    ...imageExtensions['webp'],
    ...imageExtensions['gif'],
    ...imageExtensions['tiff'],
];
const thumbnailablePdfExtension = pdfExtensions['pdf'];
const thumbnailableExtension = [...thumbnailableImageExtension];
const isFileThumbnailable = (fileType) => {
    return fileType.trim().length > 0 && thumbnailableExtension.includes(fileType.trim().toLowerCase());
};
exports.isFileThumbnailable = isFileThumbnailable;
const isPDFThumbnailable = (fileType) => {
    return fileType.trim().length > 0 && thumbnailablePdfExtension.includes(fileType.trim().toLowerCase());
};
exports.isPDFThumbnailable = isPDFThumbnailable;
const isImageThumbnailable = (fileType) => {
    return fileType.trim().length > 0 && thumbnailableImageExtension.includes(fileType.trim().toLowerCase());
};
exports.isImageThumbnailable = isImageThumbnailable;
const tryUploadThumbnail = async ({ bufferStream, fileType, userBucket, fileUuid, networkFacade, }) => {
    try {
        const thumbnailBuffer = bufferStream.getBuffer();
        if (thumbnailBuffer) {
            await thumbnail_service_1.ThumbnailService.instance.uploadThumbnail(thumbnailBuffer, fileType, userBucket, fileUuid, networkFacade);
        }
    }
    catch (error) {
        errors_utils_1.ErrorUtils.report(error);
    }
};
exports.tryUploadThumbnail = tryUploadThumbnail;
const createFileStreamWithBuffer = ({ path, fileType, }) => {
    const readable = (0, node_fs_1.createReadStream)(path);
    if ((0, exports.isFileThumbnailable)(fileType)) {
        const bufferStream = new stream_utils_1.BufferStream();
        return {
            bufferStream,
            fileStream: readable.pipe(bufferStream),
        };
    }
    return { fileStream: readable };
};
exports.createFileStreamWithBuffer = createFileStreamWithBuffer;
