import { Readable } from 'node:stream';
import { NetworkFacade } from '../services/network/network-facade.service';
import { BufferStream } from './stream.utils';
export declare const ThumbnailConfig: {
    readonly MaxWidth: 300;
    readonly MaxHeight: 300;
    readonly Quality: 100;
    readonly Type: "png";
};
export declare const isFileThumbnailable: (fileType: string) => boolean;
export declare const isPDFThumbnailable: (fileType: string) => boolean;
export declare const isImageThumbnailable: (fileType: string) => boolean;
export declare const tryUploadThumbnail: ({ bufferStream, fileType, userBucket, fileUuid, networkFacade, }: {
    bufferStream: BufferStream;
    fileType: string;
    userBucket: string;
    fileUuid: string;
    networkFacade: NetworkFacade;
}) => Promise<void>;
export declare const createFileStreamWithBuffer: ({ path, fileType, }: {
    path: string;
    fileType: string;
}) => {
    bufferStream?: BufferStream;
    fileStream: Readable;
};
