import { ReadStream, WriteStream } from 'node:fs';
import { Transform, TransformCallback, TransformOptions } from 'node:stream';
export declare class StreamUtils {
    static readStreamToReadableStream(readStream: ReadStream): ReadableStream<Uint8Array>;
    static writeStreamToWritableStream(writeStream: WriteStream): WritableStream<Uint8Array>;
    static joinReadableBinaryStreams(streams: ReadableStream<Uint8Array>[]): ReadableStream<Uint8Array>;
}
export declare class BufferStream extends Transform {
    buffer: Buffer | null;
    constructor(opts?: TransformOptions);
    _transform(chunk: Buffer, _: BufferEncoding, callback: TransformCallback): void;
    _flush(callback: TransformCallback): void;
    reset(): void;
    getBuffer(): Buffer | null;
}
