"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.webdavLogger = exports.logger = void 0;
const winston_1 = __importDefault(require("winston"));
const config_service_1 = require("../services/config.service");
const maxLogSize = 40 * 1024 * 1024;
const maxLogsFiles = 5;
exports.logger = winston_1.default.createLogger({
    level: 'info',
    format: winston_1.default.format.combine(winston_1.default.format.timestamp(), winston_1.default.format.json()),
    defaultMeta: { service: 'internxt-cli' },
    transports: [
        new winston_1.default.transports.File({
            filename: 'internxt-cli-error.log',
            level: 'error',
            dirname: config_service_1.ConfigService.INTERNXT_CLI_LOGS_DIR,
            maxsize: maxLogSize,
            maxFiles: maxLogsFiles,
            tailable: true,
        }),
        new winston_1.default.transports.File({
            filename: 'internxt-cli-combined.log',
            dirname: config_service_1.ConfigService.INTERNXT_CLI_LOGS_DIR,
            maxsize: maxLogSize,
            maxFiles: maxLogsFiles,
            tailable: true,
        }),
    ],
});
exports.webdavLogger = winston_1.default.createLogger({
    level: 'info',
    format: winston_1.default.format.combine(winston_1.default.format.timestamp(), winston_1.default.format.json()),
    defaultMeta: { service: 'internxt-webdav' },
    transports: [
        new winston_1.default.transports.File({
            filename: 'internxt-webdav-error.log',
            level: 'error',
            dirname: config_service_1.ConfigService.INTERNXT_CLI_LOGS_DIR,
            maxsize: maxLogSize,
            maxFiles: maxLogsFiles,
            tailable: true,
        }),
        new winston_1.default.transports.File({
            filename: 'internxt-webdav-combined.log',
            dirname: config_service_1.ConfigService.INTERNXT_CLI_LOGS_DIR,
            maxsize: maxLogSize,
            maxFiles: maxLogsFiles,
            tailable: true,
        }),
    ],
});
if (process.env.NODE_ENV !== 'production') {
    exports.webdavLogger.add(new winston_1.default.transports.Console({
        format: winston_1.default.format.simple(),
    }));
}
if (process.env.NODE_ENV !== 'production') {
    exports.logger.add(new winston_1.default.transports.Console({
        format: winston_1.default.format.simple(),
    }));
}
