export declare function isError(error: unknown): error is Error;
export declare function isAlreadyExistsError(error: unknown): error is Error;
export declare class ErrorUtils {
    static report(error: unknown, props?: Record<string, unknown>): void;
}
export declare class ConflictError extends Error {
    statusCode: number;
    constructor(message: string);
}
export declare class NotFoundError extends Error {
    statusCode: number;
    constructor(message: string);
}
export declare class BadRequestError extends Error {
    statusCode: number;
    constructor(message: string);
}
export declare class UnsupportedMediaTypeError extends Error {
    statusCode: number;
    constructor(message: string);
}
export declare class MethodNotAllowed extends Error {
    statusCode: number;
    constructor(message: string);
}
export declare class NotImplementedError extends Error {
    statusCode: number;
    constructor(message: string);
}
