"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DriveUtils = void 0;
class DriveUtils {
    static driveFileMetaToItem(fileMeta) {
        return {
            itemType: 'file',
            uuid: fileMeta.uuid ?? '',
            status: fileMeta.status,
            folderId: fileMeta.folderId,
            folderUuid: fileMeta.folderUuid,
            size: Number(fileMeta.size),
            name: fileMeta.plainName ?? fileMeta.name,
            bucket: fileMeta.bucket,
            createdAt: new Date(fileMeta.createdAt),
            updatedAt: new Date(fileMeta.updatedAt),
            creationTime: new Date(fileMeta.creationTime ?? fileMeta.createdAt),
            modificationTime: new Date(fileMeta.modificationTime ?? fileMeta.updatedAt),
            fileId: fileMeta.fileId,
            id: fileMeta.id,
            type: fileMeta.type,
        };
    }
    static driveFolderMetaToItem(folderMeta) {
        return {
            itemType: 'folder',
            uuid: folderMeta.uuid,
            id: folderMeta.id,
            bucket: folderMeta.bucket,
            status: folderMeta.deleted || folderMeta.removed ? 'TRASHED' : 'EXISTS',
            name: folderMeta.plainName ?? folderMeta.name,
            encryptedName: folderMeta.name,
            parentId: folderMeta.parentId,
            parentUuid: folderMeta.parentUuid,
            createdAt: new Date(folderMeta.createdAt),
            updatedAt: new Date(folderMeta.updatedAt),
        };
    }
    static createFolderResponseToItem(folderResponse) {
        return {
            itemType: 'folder',
            uuid: folderResponse.uuid,
            id: folderResponse.id,
            bucket: folderResponse.bucket,
            status: folderResponse.deleted || folderResponse.removed ? 'TRASHED' : 'EXISTS',
            name: folderResponse.plainName ?? folderResponse.name,
            encryptedName: folderResponse.name,
            parentId: folderResponse.parentId,
            parentUuid: folderResponse.parentUuid,
            createdAt: new Date(folderResponse.createdAt),
            updatedAt: new Date(folderResponse.updatedAt),
        };
    }
}
exports.DriveUtils = DriveUtils;
