import cliProgress from 'cli-progress';
import { Header } from 'tty-table';
import { LoginUserDetails, PromptOptions } from '../types/command.types';
import { NetworkFacade } from '../services/network/network-facade.service';
export declare class CLIUtils {
    static readonly clearPreviousLine: (jsonFlag?: boolean) => void;
    static readonly warning: (reporter: (message: string) => void, message: string) => void;
    static readonly error: (reporter: (message: string) => void, message: string) => void;
    static readonly success: (reporter: (message: string) => void, message: string) => void;
    static readonly log: (reporter: (message: string) => void, message: string) => void;
    static readonly consoleLog: (message: string) => void;
    static readonly doing: (message: string, jsonFlag?: boolean) => void;
    static readonly done: (jsonFlag?: boolean) => void;
    static readonly failed: (jsonFlag?: boolean) => void;
    static readonly progress: (opts: cliProgress.Options, jsonFlag?: boolean) => cliProgress.SingleBar | undefined;
    static readonly table: (reporter: (message: string) => void, header: Header[], rows: object[]) => void;
    static readonly generateTableHeaderFromType: <T extends object>() => Header[];
    static readonly CommonFlags: {
        'non-interactive': import("@oclif/core/interfaces").BooleanFlag<boolean>;
    };
    static readonly getValueFromFlag: (flag: {
        value?: string;
        name: string;
    }, command: {
        nonInteractive: boolean;
        maxAttempts?: number;
        prompt: {
            message: string;
            options: PromptOptions;
        };
    }, validation: {
        validate: (value: string) => Promise<boolean> | boolean;
        error: Error;
        canBeEmpty?: boolean;
    }, reporter: (message: string) => void) => Promise<string>;
    static readonly getDestinationFolderUuid: ({ destinationFolderUuidFlag, destinationFlagName, nonInteractive, reporter, }: {
        destinationFolderUuidFlag: string | undefined;
        destinationFlagName: string;
        nonInteractive: boolean;
        reporter: (message: string) => void;
    }) => Promise<string | undefined>;
    private static readonly promptWithAttempts;
    static readonly timer: () => {
        stop: () => number;
    };
    static readonly catchError: ({ error, logReporter, command, jsonFlag, }: {
        error: Error;
        command?: string;
        logReporter: (message: string) => void;
        jsonFlag?: boolean;
    }) => void;
    static readonly parseEmpty: (input: string) => Promise<string>;
    static readonly prepareNetwork: ({ jsonFlag, loginUserDetails, }: {
        jsonFlag?: boolean;
        loginUserDetails: LoginUserDetails;
    }) => NetworkFacade;
}
export declare class NoFlagProvidedError extends Error {
    constructor(flag: string);
}
