type strnumOptions = {
    hex: boolean;
    leadingZeros: boolean;
    skipLike?: RegExp;
    eNotation?: boolean;
};
export type X2jOptions = {
    preserveOrder?: boolean;
    attributeNamePrefix?: string;
    attributesGroupName?: false | string;
    textNodeName?: string;
    ignoreAttributes?: boolean | (string | RegExp)[] | ((attrName: string, jPath: string) => boolean);
    removeNSPrefix?: boolean;
    allowBooleanAttributes?: boolean;
    parseTagValue?: boolean;
    parseAttributeValue?: boolean;
    trimValues?: boolean;
    cdataPropName?: false | string;
    commentPropName?: false | string;
    tagValueProcessor?: (tagName: string, tagValue: string, jPath: string, hasAttributes: boolean, isLeafNode: boolean) => unknown;
    attributeValueProcessor?: (attrName: string, attrValue: string, jPath: string) => unknown;
    numberParseOptions?: strnumOptions;
    stopNodes?: string[];
    unpairedTags?: string[];
    alwaysCreateTextNode?: boolean;
    isArray?: (tagName: string, jPath: string, isLeafNode: boolean, isAttribute: boolean) => boolean;
    processEntities?: boolean;
    htmlEntities?: boolean;
    ignoreDeclaration?: boolean;
    ignorePiTags?: boolean;
    transformTagName?: ((tagName: string) => string) | false;
    transformAttributeName?: ((attributeName: string) => string) | false;
    updateTag?: (tagName: string, jPath: string, attrs: {
        [k: string]: string;
    }) => string | boolean;
    captureMetaData?: boolean;
};
export type XmlBuilderOptions = {
    attributeNamePrefix?: string;
    attributesGroupName?: false | string;
    textNodeName?: string;
    ignoreAttributes?: boolean | (string | RegExp)[] | ((attrName: string, jPath: string) => boolean);
    cdataPropName?: false | string;
    commentPropName?: false | string;
    format?: boolean;
    indentBy?: string;
    arrayNodeName?: string;
    suppressEmptyNode?: boolean;
    suppressUnpairedNode?: boolean;
    suppressBooleanAttributes?: boolean;
    preserveOrder?: boolean;
    unpairedTags?: string[];
    stopNodes?: string[];
    tagValueProcessor?: (name: string, value: unknown) => unknown;
    attributeValueProcessor?: (name: string, value: unknown) => unknown;
    processEntities?: boolean;
    oneListGroup?: boolean;
};
export {};
