export declare class ValidationService {
    static readonly instance: ValidationService;
    validateEmail: (email: string) => boolean;
    validate2FA: (code: string) => boolean;
    validateMnemonic: (mnemonic: string) => boolean;
    validateUUIDv4: (uuid: string) => boolean;
    validateYesOrNoString: (message: string) => boolean;
    validateTCPIntegerPort: (port: string) => boolean;
    validateStringIsNotEmpty: (str: string) => boolean;
    validateDirectoryExists: (path: string) => Promise<boolean>;
    validateFileExists: (path: string) => Promise<boolean>;
    validateTokenAndCheckExpiration: (token?: string) => {
        isValid: boolean;
        expiration: {
            expired: boolean;
            refreshRequired: boolean;
        };
    };
}
