"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsageService = void 0;
const sdk_manager_service_1 = require("./sdk-manager.service");
class UsageService {
    static instance = new UsageService();
    static INFINITE_LIMIT = 99 * Math.pow(1024, 4);
    fetchUsage = async () => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        const driveUsage = await storageClient.spaceUsageV2();
        return driveUsage;
    };
    fetchSpaceLimit = async () => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        const spaceLimit = await storageClient.spaceLimitV2();
        return spaceLimit.maxSpaceBytes;
    };
}
exports.UsageService = UsageService;
