"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThumbnailService = void 0;
const node_stream_1 = require("node:stream");
const drive_file_service_1 = require("./drive/drive-file.service");
const drive_1 = require("@internxt/sdk/dist/drive");
const thumbnail_utils_1 = require("../utils/thumbnail.utils");
let sharpDependency = null;
const getSharp = async () => {
    if (!sharpDependency) {
        try {
            sharpDependency = (await import('sharp')).default;
        }
        catch {
            return null;
        }
    }
    return sharpDependency;
};
class ThumbnailService {
    static instance = new ThumbnailService();
    uploadThumbnail = async (fileContent, fileType, userBucket, file_id, networkFacade) => {
        let thumbnailBuffer;
        if ((0, thumbnail_utils_1.isImageThumbnailable)(fileType)) {
            thumbnailBuffer = await this.getThumbnailFromImageBuffer(fileContent);
        }
        if (thumbnailBuffer) {
            const size = thumbnailBuffer.length;
            const fileId = await new Promise((resolve, reject) => {
                networkFacade.uploadFile(node_stream_1.Readable.from(thumbnailBuffer), size, userBucket, (err, res) => {
                    if (err) {
                        return reject(err);
                    }
                    resolve(res);
                }, () => { });
            });
            const createdThumbnailFile = await drive_file_service_1.DriveFileService.instance.createThumbnail({
                fileUuid: file_id,
                maxWidth: thumbnail_utils_1.ThumbnailConfig.MaxWidth,
                maxHeight: thumbnail_utils_1.ThumbnailConfig.MaxHeight,
                type: thumbnail_utils_1.ThumbnailConfig.Type,
                size: size,
                bucketId: userBucket,
                bucketFile: fileId,
                encryptVersion: drive_1.StorageTypes.EncryptionVersion.Aes03,
            });
            return createdThumbnailFile;
        }
    };
    getThumbnailFromImageBuffer = async (buffer) => {
        const sharp = await getSharp();
        if (sharp) {
            return sharp(buffer, { failOnError: false })
                .resize({
                height: thumbnail_utils_1.ThumbnailConfig.MaxHeight,
                width: thumbnail_utils_1.ThumbnailConfig.MaxWidth,
                fit: 'inside',
            })
                .png({
                quality: thumbnail_utils_1.ThumbnailConfig.Quality,
            })
                .toBuffer();
        }
    };
}
exports.ThumbnailService = ThumbnailService;
