"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SdkManager = void 0;
const sdk_1 = require("@internxt/sdk");
const drive_1 = require("@internxt/sdk/dist/drive");
const config_service_1 = require("./config.service");
const package_json_1 = __importDefault(require("../../package.json"));
const network_utils_1 = require("../utils/network.utils");
class SdkManager {
    static instance = new SdkManager();
    static apiSecurity;
    static init = (apiSecurity) => {
        SdkManager.apiSecurity = apiSecurity;
    };
    static clean = () => {
        SdkManager.apiSecurity = undefined;
    };
    static getApiSecurity = (config = { throwErrorOnMissingCredentials: true }) => {
        if (!SdkManager.apiSecurity && config.throwErrorOnMissingCredentials)
            throw new Error('Api security properties not found in SdkManager');
        return SdkManager.apiSecurity;
    };
    static getAppDetails = () => {
        return {
            clientName: package_json_1.default.clientName,
            clientVersion: package_json_1.default.version,
            desktopHeader: config_service_1.ConfigService.instance.get('DESKTOP_HEADER'),
        };
    };
    getAuth() {
        const DRIVE_API_URL = config_service_1.ConfigService.instance.get('DRIVE_NEW_API_URL');
        const apiSecurity = SdkManager.getApiSecurity({ throwErrorOnMissingCredentials: false });
        const appDetails = SdkManager.getAppDetails();
        return sdk_1.Auth.client(DRIVE_API_URL, appDetails, apiSecurity);
    }
    getUsers() {
        const DRIVE_API_URL = config_service_1.ConfigService.instance.get('DRIVE_NEW_API_URL');
        const apiSecurity = SdkManager.getApiSecurity({ throwErrorOnMissingCredentials: false });
        const appDetails = SdkManager.getAppDetails();
        return sdk_1.Drive.Users.client(DRIVE_API_URL, appDetails, apiSecurity);
    }
    getStorage() {
        const DRIVE_API_URL = config_service_1.ConfigService.instance.get('DRIVE_NEW_API_URL');
        const apiSecurity = SdkManager.getApiSecurity();
        const appDetails = SdkManager.getAppDetails();
        return sdk_1.Drive.Storage.client(DRIVE_API_URL, appDetails, apiSecurity);
    }
    getTrash() {
        const DRIVE_NEW_API_URL = config_service_1.ConfigService.instance.get('DRIVE_NEW_API_URL');
        const apiSecurity = SdkManager.getApiSecurity();
        const appDetails = SdkManager.getAppDetails();
        return drive_1.Trash.client(DRIVE_NEW_API_URL, appDetails, apiSecurity);
    }
    getShare() {
        const DRIVE_NEW_API_URL = config_service_1.ConfigService.instance.get('DRIVE_NEW_API_URL');
        const apiSecurity = SdkManager.getApiSecurity();
        const appDetails = SdkManager.getAppDetails();
        return sdk_1.Drive.Share.client(DRIVE_NEW_API_URL, appDetails, apiSecurity);
    }
    getNetwork(credentials) {
        const appDetails = SdkManager.getAppDetails();
        const auth = network_utils_1.NetworkUtils.getAuthFromCredentials({
            user: credentials.user,
            pass: credentials.pass,
        });
        return sdk_1.Network.Network.client(config_service_1.ConfigService.instance.get('NETWORK_URL'), appDetails, {
            bridgeUser: auth.username,
            userId: auth.password,
        });
    }
}
exports.SdkManager = SdkManager;
