"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UploadFacade = void 0;
const node_path_1 = require("node:path");
const cli_utils_1 = require("../../../utils/cli.utils");
const logger_utils_1 = require("../../../utils/logger.utils");
const local_filesystem_service_1 = require("../../local-filesystem/local-filesystem.service");
const upload_folder_service_1 = require("./upload-folder.service");
const upload_file_service_1 = require("./upload-file.service");
const async_utils_1 = require("../../../utils/async.utils");
class UploadFacade {
    static instance = new UploadFacade();
    async uploadFolder({ localPath, destinationFolderUuid, loginUserDetails, jsonFlag, onProgress }) {
        const timer = cli_utils_1.CLIUtils.timer();
        const network = cli_utils_1.CLIUtils.prepareNetwork({ jsonFlag, loginUserDetails });
        const scanResult = await local_filesystem_service_1.LocalFilesystemService.instance.scanLocalDirectory(localPath);
        logger_utils_1.logger.info(`Scanned folder ${localPath}: found ${scanResult.totalItems} items, total size ${scanResult.totalBytes} bytes.`);
        const currentProgress = { itemsUploaded: 0, bytesUploaded: 0 };
        const emitProgress = () => {
            const itemProgress = currentProgress.itemsUploaded / scanResult.totalItems;
            const sizeProgress = currentProgress.bytesUploaded / scanResult.totalBytes;
            const percentage = Math.floor((itemProgress * 0.5 + sizeProgress * 0.5) * 100);
            onProgress({ percentage });
        };
        const folderMap = await upload_folder_service_1.UploadFolderService.instance.createFolders({
            foldersToCreate: scanResult.folders,
            destinationFolderUuid,
            currentProgress,
            emitProgress,
        });
        if (folderMap.size === 0) {
            throw new Error('Failed to create folders, cannot upload files');
        }
        await async_utils_1.AsyncUtils.sleep(500);
        const totalBytes = await upload_file_service_1.UploadFileService.instance.uploadFilesInChunks({
            network,
            filesToUpload: scanResult.files,
            folderMap,
            bucket: loginUserDetails.bucket,
            destinationFolderUuid,
            currentProgress,
            emitProgress,
        });
        const rootFolderName = (0, node_path_1.basename)(localPath);
        const rootFolderId = folderMap.get(rootFolderName) ?? '';
        return {
            totalBytes,
            rootFolderId,
            uploadTimeMs: timer.stop(),
        };
    }
}
exports.UploadFacade = UploadFacade;
