"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkFacade = void 0;
const sdk_1 = require("@internxt/sdk");
const NetworkDownload = __importStar(require("@internxt/sdk/dist/network/download"));
const inxt_js_1 = require("@internxt/inxt-js");
const node_crypto_1 = require("node:crypto");
const validation_service_1 = require("../validation.service");
const TWENTY_GIGABYTES = 20 * 1024 * 1024 * 1024;
class NetworkFacade {
    network;
    environment;
    downloadService;
    cryptoService;
    cryptoLib;
    constructor(network, environment, downloadService, cryptoService) {
        this.network = network;
        this.environment = environment;
        this.downloadService = downloadService;
        this.cryptoService = cryptoService;
        this.cryptoLib = {
            algorithm: sdk_1.Network.ALGORITHMS.AES256CTR,
            validateMnemonic: (mnemonic) => {
                return validation_service_1.ValidationService.instance.validateMnemonic(mnemonic);
            },
            generateFileKey: (mnemonic, bucketId, index) => {
                return inxt_js_1.Environment.utils.generateFileKey(mnemonic, bucketId, index);
            },
            randomBytes: node_crypto_1.randomBytes,
        };
    }
    async downloadToStream(bucketId, mnemonic, fileId, size, to, rangeOptions, options) {
        const encryptedContentStreams = [];
        let fileStream;
        const abortable = options?.abortController ?? new AbortController();
        const onProgress = (loadedBytes) => {
            if (!options?.progressCallback)
                return;
            const reportedProgress = Math.round((loadedBytes / size) * 100);
            options.progressCallback(reportedProgress);
        };
        const decryptFile = async (_, key, iv) => {
            let startOffsetByte;
            if (rangeOptions) {
                startOffsetByte = rangeOptions.parsed.start;
            }
            fileStream = this.cryptoService.decryptStream(encryptedContentStreams, Buffer.from(key), Buffer.from(iv), startOffsetByte);
            await fileStream.pipeTo(to);
        };
        const downloadFile = async (downloadables) => {
            if (rangeOptions && downloadables.length > 1) {
                throw new Error('Multi-Part Download with Range-Requests is not implemented');
            }
            for (const downloadable of downloadables) {
                if (abortable.signal.aborted) {
                    throw new Error('Download aborted');
                }
                const encryptedContentStream = await this.downloadService.downloadFile(downloadable.url, {
                    progressCallback: onProgress,
                    abortController: options?.abortController,
                    rangeHeader: rangeOptions?.range,
                });
                encryptedContentStreams.push(encryptedContentStream);
            }
        };
        const downloadOperation = async () => {
            await NetworkDownload.downloadFile(fileId, bucketId, mnemonic, this.network, this.cryptoLib, Buffer.from, downloadFile, decryptFile);
        };
        return [downloadOperation(), abortable];
    }
    uploadFile(from, size, bucketId, finishedCallback, progressCallback) {
        if (size > TWENTY_GIGABYTES) {
            throw new Error('File is too big (more than 20 GB)');
        }
        const minimumMultipartThreshold = 100 * 1024 * 1024;
        const useMultipart = size > minimumMultipartThreshold;
        if (useMultipart) {
            return this.environment.uploadMultipartFile(bucketId, {
                source: from,
                fileSize: size,
                finishedCallback,
                progressCallback,
            });
        }
        else {
            return this.environment.upload(bucketId, {
                source: from,
                fileSize: size,
                finishedCallback,
                progressCallback,
            });
        }
    }
}
exports.NetworkFacade = NetworkFacade;
