"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DownloadService = void 0;
const axios_1 = __importDefault(require("axios"));
class DownloadService {
    static instance = new DownloadService();
    async downloadFile(url, options) {
        const response = await axios_1.default.get(url, {
            responseType: 'stream',
            onDownloadProgress(progressEvent) {
                if (options.progressCallback && progressEvent.loaded) {
                    options.progressCallback(progressEvent.loaded);
                }
            },
            headers: {
                range: options.rangeHeader,
            },
        });
        const readable = new ReadableStream({
            start(controller) {
                response.data.on('data', (chunk) => {
                    controller.enqueue(chunk);
                });
                response.data.on('end', () => {
                    controller.close();
                });
            },
        });
        return readable;
    }
}
exports.DownloadService = DownloadService;
