"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeysService = void 0;
const lib_1 = require("@internxt/lib");
const openpgp = __importStar(require("openpgp"));
const crypto_utils_1 = require("../utils/crypto.utils");
class KeysService {
    static instance = new KeysService();
    encryptPrivateKey = (privateKey, password) => {
        return lib_1.aes.encrypt(privateKey, password, crypto_utils_1.CryptoUtils.getAesInit());
    };
    decryptPrivateKey = (privateKey, password) => {
        return lib_1.aes.decrypt(privateKey, password);
    };
    generateNewKeysWithEncrypted = async (password) => {
        const { privateKey, publicKey, revocationCertificate } = await openpgp.generateKey({
            userIDs: [{ email: 'inxt@inxt.com' }],
            curve: 'ed25519Legacy',
        });
        return {
            privateKeyArmored: privateKey,
            privateKeyArmoredEncrypted: this.encryptPrivateKey(privateKey, password),
            publicKeyArmored: Buffer.from(publicKey).toString('base64'),
            revocationCertificate: Buffer.from(revocationCertificate).toString('base64'),
        };
    };
}
exports.KeysService = KeysService;
