"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrashService = void 0;
const sdk_manager_service_1 = require("../sdk-manager.service");
class TrashService {
    static instance = new TrashService();
    trashItems = (payload) => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        return storageClient.addItemsToTrash(payload);
    };
    deleteFile = (fileId) => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        return storageClient.deleteFileByUuid(fileId);
    };
    deleteFolder = (folderId) => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        return storageClient.deleteFolderByUuid(folderId);
    };
    clearTrash = () => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getTrash();
        return storageClient.clearTrash();
    };
    getTrashFolderContent = async () => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getTrash();
        const folders = await this.getAllTrashSubfolders(storageClient, 0);
        const files = await this.getAllTrashSubfiles(storageClient, 0);
        return { folders, files };
    };
    getAllTrashSubfolders = async (storageClient, offset) => {
        const folderContentPromise = storageClient.getTrashedFilesPaginated(50, offset, 'folders', true);
        const { result: folders } = (await folderContentPromise);
        if (folders.length > 0) {
            return folders.concat(await this.getAllTrashSubfolders(storageClient, offset + folders.length));
        }
        else {
            return folders;
        }
    };
    getAllTrashSubfiles = async (storageClient, offset) => {
        const folderContentPromise = storageClient.getTrashedFilesPaginated(50, offset, 'files', true);
        const { result: folders } = (await folderContentPromise);
        if (folders.length > 0) {
            return folders.concat(await this.getAllTrashSubfiles(storageClient, offset + folders.length));
        }
        else {
            return folders;
        }
    };
}
exports.TrashService = TrashService;
