"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DriveFileService = void 0;
const sdk_manager_service_1 = require("../sdk-manager.service");
const drive_utils_1 = require("../../utils/drive.utils");
class DriveFileService {
    static instance = new DriveFileService();
    createFile = async (payload) => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        const driveFile = await storageClient.createFileEntryByUuid(payload);
        return {
            itemType: 'file',
            name: payload.plainName,
            id: driveFile.id,
            uuid: driveFile.uuid,
            size: driveFile.size,
            bucket: driveFile.bucket,
            createdAt: new Date(driveFile.createdAt),
            updatedAt: new Date(driveFile.updatedAt),
            fileId: driveFile.fileId,
            type: driveFile.type,
            status: driveFile.status,
            folderId: driveFile.folderId,
            folderUuid: driveFile.folderUuid,
            creationTime: new Date(driveFile.creationTime ?? driveFile.createdAt),
            modificationTime: new Date(driveFile.modificationTime ?? driveFile.updatedAt),
        };
    };
    getFileMetadata = async (uuid) => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        const [getFileMetadata] = storageClient.getFile(uuid);
        const fileMetadata = await getFileMetadata;
        return drive_utils_1.DriveUtils.driveFileMetaToItem(fileMetadata);
    };
    moveFile = (uuid, payload) => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        return storageClient.moveFileByUuid(uuid, payload);
    };
    renameFile = (fileUuid, payload) => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        return storageClient.updateFileMetaByUUID(fileUuid, payload);
    };
    getFileMetadataByPath = async (path) => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        const fileMetadata = await storageClient.getFileByPath(encodeURIComponent(path));
        return drive_utils_1.DriveUtils.driveFileMetaToItem(fileMetadata);
    };
    createThumbnail = (payload) => {
        const storageClient = sdk_manager_service_1.SdkManager.instance.getStorage();
        return storageClient.createThumbnailEntryWithUUID(payload);
    };
}
exports.DriveFileService = DriveFileService;
