import { StorageTypes } from '@internxt/sdk/dist/drive';
import { DriveFileItem } from '../../types/drive.types';
export declare class DriveFileService {
    static readonly instance: DriveFileService;
    createFile: (payload: StorageTypes.FileEntryByUuid) => Promise<DriveFileItem>;
    getFileMetadata: (uuid: string) => Promise<DriveFileItem>;
    moveFile: (uuid: string, payload: StorageTypes.MoveFileUuidPayload) => Promise<StorageTypes.FileMeta>;
    renameFile: (fileUuid: string, payload: {
        plainName?: string;
        type?: string | null;
    }) => Promise<void>;
    getFileMetadataByPath: (path: string) => Promise<DriveFileItem>;
    createThumbnail: (payload: StorageTypes.CreateThumbnailEntryPayload) => Promise<StorageTypes.Thumbnail>;
}
