"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DriveFolder = void 0;
class DriveFolder {
    id;
    name;
    uuid;
    relativePath;
    parentId;
    parentUuid;
    createdAt;
    updatedAt;
    status;
    constructor({ id, name, uuid, relativePath, parentId, parentUuid, createdAt, updatedAt, status, }) {
        this.id = id;
        this.name = name;
        this.uuid = uuid;
        this.relativePath = relativePath;
        this.parentId = parentId;
        this.parentUuid = parentUuid;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.status = status;
    }
    static build(folder) {
        return new DriveFolder(folder);
    }
    toJSON() {
        return {
            id: this.id,
            name: this.name,
            uuid: this.uuid,
            status: this.status,
            relativePath: this.relativePath,
            parentId: this.parentId,
            parentUuid: this.parentUuid,
            createdAt: this.createdAt,
            updatedAt: this.updatedAt,
        };
    }
    toItem() {
        return {
            itemType: 'folder',
            id: this.id,
            name: this.name,
            uuid: this.uuid,
            status: this.status,
            parentId: this.parentId,
            parentUuid: this.parentUuid,
            createdAt: this.createdAt,
            updatedAt: this.updatedAt,
            encryptedName: '',
            bucket: null,
        };
    }
}
exports.DriveFolder = DriveFolder;
