import { CryptoProvider } from '@internxt/sdk';
export declare class CryptoService {
    static readonly instance: CryptoService;
    static readonly cryptoProvider: CryptoProvider;
    passToHash: (passObject: {
        password: string;
        salt?: string | null;
    }) => {
        salt: string;
        hash: string;
    };
    encryptText: (textToEncrypt: string) => string;
    decryptText: (encryptedText: string) => string;
    encryptTextWithKey: (textToEncrypt: string, secret: string) => string;
    decryptTextWithKey: (encryptedText: string, secret: string) => string;
    decryptStream: (inputSlices: ReadableStream<Uint8Array>[], key: Buffer, iv: Buffer, startOffsetByte?: number) => ReadableStream<any>;
    private readonly getKeyAndIvFrom;
}
