import { Command } from '@oclif/core';
export default class Webdav extends Command {
    static readonly args: {
        action: import("@oclif/core/interfaces").Arg<string, Record<string, unknown>>;
    };
    static readonly description = "Enable, disable, restart or get the status of the Internxt CLI WebDav server";
    static readonly aliases: never[];
    static readonly examples: string[];
    static readonly flags: {};
    static readonly enableJsonFlag = true;
    run: () => Promise<{
        success: boolean;
        message: string;
        action: string;
    }>;
    catch: (error: Error) => Promise<never>;
    private enableWebDav;
    private disableWebDav;
    private restartWebDav;
    private webDAVStatus;
}
