import { Command } from '@oclif/core';
export default class WebDAVConfig extends Command {
    static readonly args: {};
    static readonly description = "Edit the configuration of the Internxt CLI WebDav server as the port or the protocol.";
    static readonly aliases: never[];
    static readonly examples: string[];
    static readonly flags: {
        host: import("@oclif/core/interfaces").OptionFlag<string | undefined, import("@oclif/core/interfaces").CustomOptions>;
        port: import("@oclif/core/interfaces").OptionFlag<string | undefined, import("@oclif/core/interfaces").CustomOptions>;
        https: import("@oclif/core/interfaces").BooleanFlag<boolean>;
        http: import("@oclif/core/interfaces").BooleanFlag<boolean>;
        timeout: import("@oclif/core/interfaces").OptionFlag<number | undefined, import("@oclif/core/interfaces").CustomOptions>;
        createFullPath: import("@oclif/core/interfaces").BooleanFlag<boolean>;
    };
    static readonly enableJsonFlag = true;
    run: () => Promise<{
        success: boolean;
        message: string;
        config: import("../types/command.types").WebdavConfig;
    }>;
    catch: (error: Error) => Promise<never>;
}
