import { Command } from '@oclif/core';
export default class UploadFile extends Command {
    static readonly args: {};
    static readonly description = "Upload a file to Internxt Drive";
    static readonly aliases: string[];
    static readonly examples: string[];
    static readonly flags: {
        file: import("@oclif/core/interfaces").OptionFlag<string | undefined, import("@oclif/core/interfaces").CustomOptions>;
        destination: import("@oclif/core/interfaces").OptionFlag<string | undefined, import("@oclif/core/interfaces").CustomOptions>;
        'non-interactive': import("@oclif/core/interfaces").BooleanFlag<boolean>;
    };
    static readonly enableJsonFlag = true;
    run: () => Promise<{
        success: boolean;
        message: string;
        file: {
            plainName: string;
            status: "EXISTS" | "TRASHED" | "DELETED";
            name: string;
            id: number;
            uuid: string;
            fileId: string | null;
            bucket: string;
            folderId: number;
            folderUuid: string;
            itemType: "file";
            size: number;
            createdAt: Date;
            updatedAt: Date;
            creationTime: Date;
            modificationTime: Date;
            type?: string | null;
        };
    }>;
    catch: (error: Error) => Promise<never>;
    private getFilePath;
}
