import { Command } from '@oclif/core';
export default class TrashRestoreFolder extends Command {
    static readonly args: {};
    static readonly description = "Restore a trashed folder into a destination folder.";
    static readonly aliases: string[];
    static readonly examples: string[];
    static readonly flags: {
        id: import("@oclif/core/interfaces").OptionFlag<string | undefined, import("@oclif/core/interfaces").CustomOptions>;
        destination: import("@oclif/core/interfaces").OptionFlag<string | undefined, import("@oclif/core/interfaces").CustomOptions>;
        'non-interactive': import("@oclif/core/interfaces").BooleanFlag<boolean>;
    };
    static readonly enableJsonFlag = true;
    run: () => Promise<{
        success: boolean;
        message: string;
        folder: import("@internxt/sdk/dist/drive/storage/types").FolderMeta;
    }>;
    catch: (error: Error) => Promise<never>;
    private getFolderUuid;
    private getDestinationFolderUuid;
}
