import { Command } from '@oclif/core';
export default class TrashList extends Command {
    static readonly args: {};
    static readonly description = "Lists the content of the trash.";
    static readonly aliases: string[];
    static readonly examples: string[];
    static readonly flags: {
        extended: import("@oclif/core/interfaces").BooleanFlag<boolean>;
    };
    static readonly enableJsonFlag = true;
    run: () => Promise<{
        success: boolean;
        list: {
            folders: {
                type: string;
                id: number;
                parentId: number;
                parentUuid: string;
                name: string;
                parent: import("@internxt/sdk/dist/schema").components["schemas"]["Folder"];
                bucket: string;
                userId: number;
                encryptVersion: string;
                createdAt: string;
                updatedAt: string;
                uuid: string;
                plainName: string;
                size: number;
                creationTime: string;
                modificationTime: string;
                status: "EXISTS" | "TRASHED" | "DELETED";
                removed: boolean;
                deleted: boolean;
            }[];
            files: {
                id: number;
                uuid: string;
                fileId: string | null;
                name: string;
                type: string;
                size: string;
                bucket: string;
                folderId: number;
                folderUuid: string;
                encryptVersion: string;
                userId: number;
                creationTime: string;
                modificationTime: string;
                createdAt: string;
                updatedAt: string;
                plainName: string;
                status: "EXISTS" | "TRASHED" | "DELETED";
            }[];
        };
    }>;
    catch: (error: Error) => Promise<never>;
}
