import { Command } from '@oclif/core';
export default class TrashFile extends Command {
    static readonly args: {};
    static readonly description = "Moves a given file to the trash.";
    static readonly aliases: string[];
    static readonly examples: string[];
    static readonly flags: {
        id: import("@oclif/core/interfaces").OptionFlag<string | undefined, import("@oclif/core/interfaces").CustomOptions>;
        'non-interactive': import("@oclif/core/interfaces").BooleanFlag<boolean>;
    };
    static readonly enableJsonFlag = true;
    run: () => Promise<{
        success: boolean;
        message: string;
        file: {
            uuid: string;
        };
    }>;
    catch: (error: Error) => Promise<never>;
    private getFileUuid;
}
