import { Command } from '@oclif/core';
export default class TrashClear extends Command {
    static readonly args: {};
    static readonly description = "Deletes permanently all the content of the trash. This action cannot be undone.";
    static readonly aliases: string[];
    static readonly examples: string[];
    static readonly flags: {
        force: import("@oclif/core/interfaces").BooleanFlag<boolean>;
        'non-interactive': import("@oclif/core/interfaces").BooleanFlag<boolean>;
    };
    static readonly enableJsonFlag = true;
    run: () => Promise<{
        success: boolean;
        message: string;
    }>;
    catch: (error: Error) => Promise<never>;
    private getConfirmation;
    private getConfirmationInteractively;
}
