import { Command } from '@oclif/core';
export default class RenameFolder extends Command {
    static readonly args: {};
    static readonly description = "Rename a folder.";
    static readonly aliases: string[];
    static readonly examples: string[];
    static readonly flags: {
        id: import("@oclif/core/interfaces").OptionFlag<string | undefined, import("@oclif/core/interfaces").CustomOptions>;
        name: import("@oclif/core/interfaces").OptionFlag<string | undefined, import("@oclif/core/interfaces").CustomOptions>;
        'non-interactive': import("@oclif/core/interfaces").BooleanFlag<boolean>;
    };
    static readonly enableJsonFlag = true;
    run: () => Promise<{
        success: boolean;
        message: string;
        folder: {
            uuid: string;
            plainName: string;
        };
    }>;
    catch: (error: Error) => Promise<never>;
    private getFolderUuid;
    private getFolderName;
}
