import { Command } from '@oclif/core';
export default class MoveFile extends Command {
    static readonly args: {};
    static readonly description = "Move a file into a destination folder.";
    static readonly aliases: string[];
    static readonly examples: string[];
    static readonly flags: {
        id: import("@oclif/core/interfaces").OptionFlag<string | undefined, import("@oclif/core/interfaces").CustomOptions>;
        destination: import("@oclif/core/interfaces").OptionFlag<string | undefined, import("@oclif/core/interfaces").CustomOptions>;
        'non-interactive': import("@oclif/core/interfaces").BooleanFlag<boolean>;
    };
    static readonly enableJsonFlag = true;
    run: () => Promise<{
        success: boolean;
        message: string;
        file: {
            id: number;
            uuid: string;
            fileId: string | null;
            name: string;
            type: string;
            size: string;
            bucket: string;
            folderId: number;
            folderUuid: string;
            encryptVersion: string;
            userId: number;
            creationTime: string;
            modificationTime: string;
            createdAt: string;
            updatedAt: string;
            plainName: string;
            status: "EXISTS" | "TRASHED" | "DELETED";
        };
    }>;
    catch: (error: Error) => Promise<never>;
    private getFileUuid;
    private getDestinationFolderUuid;
}
