"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@oclif/core");
const config_service_1 = require("../services/config.service");
const cli_utils_1 = require("../utils/cli.utils");
const sdk_manager_service_1 = require("../services/sdk-manager.service");
const universal_link_service_1 = require("../services/universal-link.service");
class Login extends core_1.Command {
    static args = {};
    static description = 'Logs into your Internxt account using the web-based login flow. ' +
        'A temporary local server is started to securely receive the authentication response.';
    static aliases = [];
    static examples = ['<%= config.bin %> <%= command.id %>'];
    static flags = {
        host: core_1.Flags.string({
            char: 'h',
            aliases: ['host'],
            env: 'INXT_LOGIN_SERVER_HOST',
            description: 'IP address of the machine where the CLI is running. ' +
                'If you are opening the login page in a browser on another device, ' +
                'set this to the IP address of the machine running the CLI. Defaults to 127.0.0.1.',
            required: false,
        }),
        port: core_1.Flags.integer({
            char: 'p',
            aliases: ['port'],
            env: 'INXT_LOGIN_SERVER_PORT',
            description: 'Port used by the temporary local server to handle the login callback. ' +
                'If not specified, a random available port will be used automatically.',
            required: false,
        }),
    };
    static enableJsonFlag = true;
    run = async () => {
        const { flags } = await this.parse(Login);
        const host = flags['host'];
        const port = flags['port'];
        const loginCredentials = await universal_link_service_1.UniversalLinkService.instance.loginSSO(flags['json'] ?? false, this.log.bind(this), host, port);
        sdk_manager_service_1.SdkManager.init({ token: loginCredentials.token });
        await config_service_1.ConfigService.instance.saveUser(loginCredentials);
        const message = `Succesfully logged in to: ${loginCredentials.user.email}`;
        cli_utils_1.CLIUtils.success(this.log.bind(this), message);
        return {
            success: true,
            message,
            login: loginCredentials,
        };
    };
    catch = async (error) => {
        const { flags } = await this.parse(Login);
        cli_utils_1.CLIUtils.catchError({
            error,
            command: this.id,
            logReporter: this.log.bind(this),
            jsonFlag: flags['json'],
        });
        this.exit(1);
    };
}
exports.default = Login;
