"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@oclif/core");
const command_types_1 = require("../types/command.types");
const auth_service_1 = require("../services/auth.service");
const config_service_1 = require("../services/config.service");
const validation_service_1 = require("../services/validation.service");
const cli_utils_1 = require("../utils/cli.utils");
const sdk_manager_service_1 = require("../services/sdk-manager.service");
const OTPAuth = __importStar(require("otpauth"));
class LoginLegacy extends core_1.Command {
    static args = {};
    static description = '[Legacy] Logs into an Internxt account using user and password. ' +
        'If the account is two-factor protected, then an extra code will be required.';
    static aliases = [];
    static examples = ['<%= config.bin %> <%= command.id %>'];
    static flags = {
        ...cli_utils_1.CLIUtils.CommonFlags,
        email: core_1.Flags.string({
            char: 'e',
            aliases: ['mail'],
            env: 'INXT_USER',
            description: 'The email to log in',
            required: false,
        }),
        password: core_1.Flags.string({
            char: 'p',
            aliases: ['pass'],
            env: 'INXT_PASSWORD',
            description: 'The plain password to log in',
            required: false,
        }),
        twofactor: core_1.Flags.string({
            char: 'w',
            aliases: ['two', 'two-factor'],
            env: 'INXT_TWOFACTORCODE',
            description: 'The two factor auth code (TOTP). ',
            required: false,
            helpValue: '123456',
        }),
        twofactortoken: core_1.Flags.string({
            char: 't',
            aliases: ['otp', 'otp-token'],
            env: 'INXT_OTPTOKEN',
            description: 'The TOTP secret token. It is used to generate a TOTP code if needed.' +
                ' It has prority over the two factor code flag.',
            required: false,
            helpValue: 'token',
        }),
    };
    static enableJsonFlag = true;
    run = async () => {
        const { flags } = await this.parse(LoginLegacy);
        const nonInteractive = flags['non-interactive'];
        const email = await this.getEmail(flags['email'], nonInteractive);
        const password = await this.getPassword(flags['password'], nonInteractive);
        const is2FANeeded = await auth_service_1.AuthService.instance.is2FANeeded(email);
        let twoFactorCode;
        if (is2FANeeded) {
            const twoFactorToken = flags['twofactortoken'];
            if (twoFactorToken && twoFactorToken.trim().length > 0) {
                const totp = new OTPAuth.TOTP({
                    secret: twoFactorToken,
                    digits: 6,
                });
                twoFactorCode = totp.generate();
            }
            else {
                twoFactorCode = await this.getTwoFactorCode(flags['twofactor'], nonInteractive);
            }
        }
        const loginCredentials = await auth_service_1.AuthService.instance.doLogin(email, password, twoFactorCode);
        sdk_manager_service_1.SdkManager.init({ token: loginCredentials.token });
        await config_service_1.ConfigService.instance.saveUser(loginCredentials);
        const message = `Succesfully logged in to: ${loginCredentials.user.email}`;
        cli_utils_1.CLIUtils.success(this.log.bind(this), message);
        return {
            success: true,
            message,
            login: loginCredentials,
        };
    };
    catch = async (error) => {
        const { flags } = await this.parse(LoginLegacy);
        cli_utils_1.CLIUtils.catchError({
            error,
            command: this.id,
            logReporter: this.log.bind(this),
            jsonFlag: flags['json'],
        });
        this.exit(1);
    };
    getEmail = async (emailFlag, nonInteractive) => {
        const email = await cli_utils_1.CLIUtils.getValueFromFlag({
            value: emailFlag,
            name: LoginLegacy.flags['email'].name,
        }, {
            nonInteractive,
            prompt: {
                message: 'What is your email?',
                options: { type: 'input' },
            },
        }, {
            validate: validation_service_1.ValidationService.instance.validateEmail,
            error: new command_types_1.NotValidEmailError(),
        }, this.log.bind(this));
        return email;
    };
    getPassword = async (passwordFlag, nonInteractive) => {
        const password = await cli_utils_1.CLIUtils.getValueFromFlag({
            value: passwordFlag,
            name: LoginLegacy.flags['password'].name,
        }, {
            nonInteractive,
            prompt: {
                message: 'What is your password?',
                options: { type: 'password' },
            },
        }, {
            validate: validation_service_1.ValidationService.instance.validateStringIsNotEmpty,
            error: new command_types_1.EmptyPasswordError(),
        }, this.log.bind(this));
        return password;
    };
    getTwoFactorCode = async (twoFactorFlag, nonInteractive) => {
        const twoFactor = await cli_utils_1.CLIUtils.getValueFromFlag({
            value: twoFactorFlag,
            name: LoginLegacy.flags['twofactor'].name,
        }, {
            nonInteractive,
            prompt: {
                message: 'What is your two-factor code?',
                options: { type: 'mask' },
            },
        }, {
            validate: validation_service_1.ValidationService.instance.validate2FA,
            error: new command_types_1.NotValidTwoFactorCodeError(),
        }, this.log.bind(this));
        return twoFactor;
    };
}
exports.default = LoginLegacy;
