import { Command } from '@oclif/core';
export default class DeletePermanentlyFile extends Command {
    static readonly args: {};
    static readonly description = "Deletes permanently a file. This action cannot be undone.";
    static readonly aliases: string[];
    static readonly examples: string[];
    static readonly flags: {
        id: import("@oclif/core/interfaces").OptionFlag<string | undefined, import("@oclif/core/interfaces").CustomOptions>;
        'non-interactive': import("@oclif/core/interfaces").BooleanFlag<boolean>;
    };
    static readonly enableJsonFlag = true;
    run: () => Promise<{
        success: boolean;
        message: string;
    }>;
    catch: (error: Error) => Promise<never>;
    private getFileUuid;
}
