"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.basicHeaders = basicHeaders;
exports.basicHeadersWithPassword = basicHeadersWithPassword;
exports.headersWithToken = headersWithToken;
exports.headersWithTokenAndPassword = headersWithTokenAndPassword;
exports.headersWithBasicAuth = headersWithBasicAuth;
exports.headersWithAuthToken = headersWithAuthToken;
exports.addResourcesTokenToHeaders = addResourcesTokenToHeaders;
function basicHeaders(_a) {
    var clientName = _a.clientName, clientVersion = _a.clientVersion, customHeaders = _a.customHeaders, desktopToken = _a.desktopToken;
    var extra = {};
    if (desktopToken) {
        extra['x-internxt-desktop-header'] = desktopToken;
    }
    return __assign(__assign({ 'content-type': 'application/json; charset=utf-8', 'internxt-version': clientVersion, 'internxt-client': clientName }, extra), customHeaders);
}
function basicHeadersWithPassword(_a) {
    var clientName = _a.clientName, clientVersion = _a.clientVersion, password = _a.password, desktopToken = _a.desktopToken;
    var extra = {};
    if (desktopToken) {
        extra['x-internxt-desktop-header'] = desktopToken;
    }
    return __assign({ 'content-type': 'application/json; charset=utf-8', 'internxt-version': clientVersion, 'internxt-client': clientName, 'x-share-password': password }, extra);
}
function headersWithToken(_a) {
    var clientName = _a.clientName, clientVersion = _a.clientVersion, token = _a.token, workspaceToken = _a.workspaceToken, desktopToken = _a.desktopToken, customHeaders = _a.customHeaders;
    var headers = basicHeaders({ clientName: clientName, clientVersion: clientVersion, desktopToken: desktopToken });
    var extra = {
        Authorization: 'Bearer ' + token,
    };
    if (workspaceToken) {
        extra['x-internxt-workspace'] = workspaceToken;
    }
    return __assign(__assign(__assign({}, headers), extra), customHeaders);
}
function headersWithTokenAndPassword(_a) {
    var clientName = _a.clientName, clientVersion = _a.clientVersion, token = _a.token, workspaceToken = _a.workspaceToken, desktopToken = _a.desktopToken, password = _a.password;
    var headers = headersWithToken({ clientName: clientName, clientVersion: clientVersion, token: token, workspaceToken: workspaceToken, desktopToken: desktopToken });
    var extra = {
        'x-share-password': password,
    };
    return __assign(__assign({}, headers), extra);
}
function headersWithBasicAuth(_a) {
    var clientName = _a.clientName, clientVersion = _a.clientVersion, auth = _a.auth, workspaceToken = _a.workspaceToken, desktopToken = _a.desktopToken, customHeaders = _a.customHeaders;
    var headers = basicHeaders({ clientName: clientName, clientVersion: clientVersion, desktopToken: desktopToken });
    var token = "".concat(auth.username, ":").concat(auth.password);
    var encodedToken = Buffer.from(token).toString('base64');
    var extra = {
        Authorization: 'Basic ' + encodedToken,
    };
    if (workspaceToken !== undefined) {
        extra['x-internxt-workspace'] = workspaceToken;
    }
    return __assign(__assign(__assign({}, headers), extra), customHeaders);
}
function headersWithAuthToken(_a) {
    var clientName = _a.clientName, clientVersion = _a.clientVersion, token = _a.token, workspaceToken = _a.workspaceToken, desktopToken = _a.desktopToken, customHeaders = _a.customHeaders;
    var headers = basicHeaders({ clientName: clientName, clientVersion: clientVersion, desktopToken: desktopToken });
    var extra = {};
    if (workspaceToken !== undefined) {
        extra['x-internxt-workspace'] = workspaceToken;
    }
    return __assign(__assign(__assign(__assign({}, headers), { 'x-token': token }), extra), customHeaders);
}
function addResourcesTokenToHeaders(headers, resourcesToken) {
    if (resourcesToken && resourcesToken.length > 0) {
        return __assign(__assign({}, headers), { 'internxt-resources-token': resourcesToken });
    }
    return headers;
}
