import { BasicAuth } from '../auth/types';
import { AppDetails } from '../shared';
import { BridgeUrl, FinishMultipartUploadPayload, FinishUploadPayload, FinishUploadResponse, GetDownloadLinksResponse, NetworkRequestConfig, StartUploadPayload, StartUploadResponse } from './types';
export * from './types';
export declare class DuplicatedIndexesError extends Error {
    constructor();
}
export declare class InvalidFileIndexError extends Error {
    constructor();
}
export declare class InvalidUploadIndexError extends Error {
    constructor();
}
export declare class InvalidUploadSizeError extends Error {
    constructor();
}
export declare class FileTooSmallForMultipartError extends Error {
    constructor();
}
export declare class InvalidMultipartValueError extends Error {
    constructor();
}
export declare class Network {
    private readonly client;
    private readonly appDetails;
    private readonly auth;
    static client(apiUrl: BridgeUrl, appDetails: AppDetails, opts: {
        bridgeUser: string;
        userId: string;
    }): Network;
    private constructor();
    get credentials(): BasicAuth;
    startUpload(bucketId: string, payload: StartUploadPayload, parts?: number): Promise<StartUploadResponse>;
    finishUpload(bucketId: string, payload: FinishUploadPayload): Promise<FinishUploadResponse>;
    finishMultipartUpload(bucketId: string, payload: FinishMultipartUploadPayload): Promise<FinishUploadResponse>;
    getDownloadLinks(bucketId: string, fileId: string, token?: string): Promise<GetDownloadLinksResponse>;
    deleteFile(bucketId: string, fileId: string): Promise<void>;
    /**
     * Creates entries for every upload in the request, returns the urls to upload
     * @param bucketId
     * @param uploads
     */
    static startUpload(bucketId: string, payload: StartUploadPayload, { client, appDetails, auth }: NetworkRequestConfig, parts?: number): Promise<StartUploadResponse>;
    /**
     * Finishes the upload of a file
     * @param bucketId
     * @param index
     * @param shards
     */
    private static finishUpload;
    /**
     * Gets the download links for a file
     * @param bucketId
     * @param file
     */
    private static getDownloadLinks;
    /**
     * Deletes a file
     * @param bucketId
     * @param file
     */
    private static deleteFile;
    /**
     * Gets headers with basic auth
     * @param appDetails
     * @param auth
     */
    private static headersWithBasicAuth;
    private static headersWithAuthToken;
}
