"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var sinon_1 = __importDefault(require("sinon"));
var headers_1 = require("../shared/headers");
var client_1 = require("../shared/http/client");
var index_1 = require("./index");
var httpClient = client_1.HttpClient.create('');
describe('Meet service tests', function () {
    beforeEach(function () {
        sinon_1.default.stub(client_1.HttpClient, 'create').returns(httpClient);
    });
    afterEach(function () {
        sinon_1.default.restore();
    });
    describe('createCall method', function () {
        it('should successfully create a call with token', function () { return __awaiter(void 0, void 0, void 0, function () {
            var expectedResponse, _a, client, headers, postCall, response;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        expectedResponse = {
                            token: 'call-token',
                            room: 'room-id',
                            paxPerCall: 10,
                            appId: 'app-id',
                        };
                        _a = clientAndHeadersWithToken(), client = _a.client, headers = _a.headers;
                        postCall = sinon_1.default.stub(httpClient, 'post').resolves(expectedResponse);
                        return [4 /*yield*/, client.createCall()];
                    case 1:
                        response = _b.sent();
                        // Assert
                        expect(postCall.firstCall.args).toEqual(['call', {}, headers]);
                        expect(response).toEqual(expectedResponse);
                        return [2 /*return*/];
                }
            });
        }); });
        it('should throw an error when token is missing', function () { return __awaiter(void 0, void 0, void 0, function () {
            var client;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        client = clientAndHeadersWithoutToken().client;
                        // Act & Assert
                        return [4 /*yield*/, expect(client.createCall()).rejects.toThrow('Token is required for Meet operations')];
                    case 1:
                        // Act & Assert
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        }); });
    });
    describe('joinCall method', function () {
        var callId = 'call-123';
        var payload = {
            name: 'John',
            lastname: 'Doe',
            anonymous: false,
        };
        var joinCallResponse = {
            token: 'join-token',
            room: 'room-id',
            userId: 'user-123',
            appId: 'app-id',
        };
        it('should join a call successfully with token', function () { return __awaiter(void 0, void 0, void 0, function () {
            var _a, client, headers, postCall, response;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = clientAndHeadersWithToken(), client = _a.client, headers = _a.headers;
                        postCall = sinon_1.default.stub(httpClient, 'post').resolves(joinCallResponse);
                        return [4 /*yield*/, client.joinCall(callId, payload)];
                    case 1:
                        response = _b.sent();
                        // Assert
                        expect(postCall.firstCall.args).toEqual(["call/".concat(callId, "/users/join"), payload, headers]);
                        expect(response).toEqual(joinCallResponse);
                        return [2 /*return*/];
                }
            });
        }); });
        it('should join a call successfully without token', function () { return __awaiter(void 0, void 0, void 0, function () {
            var _a, client, headers, postCall, response;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = clientAndHeadersWithoutToken(), client = _a.client, headers = _a.headers;
                        postCall = sinon_1.default.stub(httpClient, 'post').resolves(joinCallResponse);
                        return [4 /*yield*/, client.joinCall(callId, payload)];
                    case 1:
                        response = _b.sent();
                        // Assert
                        expect(postCall.firstCall.args[0]).toEqual("call/".concat(callId, "/users/join"));
                        expect(postCall.firstCall.args[1]).toEqual(payload);
                        expect(postCall.firstCall.args[2]).toEqual(headers);
                        expect(response).toEqual(joinCallResponse);
                        return [2 /*return*/];
                }
            });
        }); });
    });
    describe('getCurrentUsersInCall method', function () {
        var callId = 'call-123';
        var usersInCallResponse = [
            {
                userId: 'user-123',
                name: 'John',
                lastname: 'Doe',
                anonymous: false,
                avatar: 'avatar-url-1',
            },
            {
                userId: 'user-456',
                name: 'Jane',
                lastname: 'Smith',
                anonymous: true,
                avatar: 'avatar-url-2',
            },
        ];
        it('should get current users in call successfully with token', function () { return __awaiter(void 0, void 0, void 0, function () {
            var _a, client, headers, getCall, response;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = clientAndHeadersWithToken(), client = _a.client, headers = _a.headers;
                        getCall = sinon_1.default.stub(httpClient, 'get').resolves(usersInCallResponse);
                        return [4 /*yield*/, client.getCurrentUsersInCall(callId)];
                    case 1:
                        response = _b.sent();
                        // Assert
                        expect(getCall.firstCall.args).toEqual(["call/".concat(callId, "/users"), headers]);
                        expect(response).toEqual(usersInCallResponse);
                        return [2 /*return*/];
                }
            });
        }); });
        it('should get current users in call successfully without token', function () { return __awaiter(void 0, void 0, void 0, function () {
            var _a, client, headers, getCall, response;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = clientAndHeadersWithoutToken(), client = _a.client, headers = _a.headers;
                        getCall = sinon_1.default.stub(httpClient, 'get').resolves(usersInCallResponse);
                        return [4 /*yield*/, client.getCurrentUsersInCall(callId)];
                    case 1:
                        response = _b.sent();
                        // Assert
                        expect(getCall.firstCall.args[0]).toEqual("call/".concat(callId, "/users"));
                        expect(getCall.firstCall.args[1]).toEqual(headers);
                        expect(response).toEqual(usersInCallResponse);
                        return [2 /*return*/];
                }
            });
        }); });
    });
    describe('leaveCall method', function () {
        var callId = 'call-123';
        it('should leave a call successfully with token', function () { return __awaiter(void 0, void 0, void 0, function () {
            var _a, client, headers, postCall;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = clientAndHeadersWithToken(), client = _a.client, headers = _a.headers;
                        postCall = sinon_1.default.stub(httpClient, 'post').resolves();
                        // Act
                        return [4 /*yield*/, client.leaveCall(callId)];
                    case 1:
                        // Act
                        _b.sent();
                        // Assert
                        expect(postCall.firstCall.args).toEqual(["call/".concat(callId, "/users/leave"), {}, headers]);
                        return [2 /*return*/];
                }
            });
        }); });
        it('should leave a call successfully without token', function () { return __awaiter(void 0, void 0, void 0, function () {
            var _a, client, headers, postCall;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = clientAndHeadersWithoutToken(), client = _a.client, headers = _a.headers;
                        postCall = sinon_1.default.stub(httpClient, 'post').resolves();
                        // Act
                        return [4 /*yield*/, client.leaveCall(callId)];
                    case 1:
                        // Act
                        _b.sent();
                        // Assert
                        expect(postCall.firstCall.args[0]).toEqual("call/".concat(callId, "/users/leave"));
                        expect(postCall.firstCall.args[1]).toEqual({});
                        expect(postCall.firstCall.args[2]).toEqual(headers);
                        return [2 /*return*/];
                }
            });
        }); });
    });
});
function clientAndHeadersWithToken(apiUrl, clientName, clientVersion, token) {
    if (apiUrl === void 0) { apiUrl = ''; }
    if (clientName === void 0) { clientName = 'c-name'; }
    if (clientVersion === void 0) { clientVersion = '0.1'; }
    if (token === void 0) { token = 'my-token'; }
    var appDetails = {
        clientName: clientName,
        clientVersion: clientVersion,
    };
    var apiSecurity = {
        token: token,
    };
    var client = index_1.Meet.client(apiUrl, appDetails, apiSecurity);
    var headers = (0, headers_1.headersWithToken)({ clientName: clientName, clientVersion: clientVersion, token: token });
    return { client: client, headers: headers };
}
function clientAndHeadersWithoutToken(apiUrl, clientName, clientVersion) {
    if (apiUrl === void 0) { apiUrl = ''; }
    if (clientName === void 0) { clientName = 'c-name'; }
    if (clientVersion === void 0) { clientVersion = '0.1'; }
    var appDetails = {
        clientName: clientName,
        clientVersion: clientVersion,
    };
    var client = index_1.Meet.client(apiUrl, appDetails);
    var headers = (0, headers_1.basicHeaders)({ clientName: clientName, clientVersion: clientVersion });
    return { client: client, headers: headers };
}
