"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Trash = exports.TrashTypes = void 0;
var headers_1 = require("../../shared/headers");
var client_1 = require("../../shared/http/client");
exports.TrashTypes = __importStar(require("./types"));
var Trash = /** @class */ (function () {
    function Trash(apiUrl, appDetails, apiSecurity) {
        this.client = client_1.HttpClient.create(apiUrl, apiSecurity.unauthorizedCallback);
        this.appDetails = appDetails;
        this.apiSecurity = apiSecurity;
    }
    Trash.client = function (apiUrl, appDetails, apiSecurity) {
        return new Trash(apiUrl, appDetails, apiSecurity);
    };
    /**
     * Removes a specific folder from the centralized persistence
     * @param folderId
     */
    Trash.prototype.deleteFolder = function (folderId) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.client.delete("/storage/folder/".concat(folderId), this.headers())];
            });
        });
    };
    /**
     * Deletes a specific file entry
     * @param payload
     */
    Trash.prototype.deleteFile = function (payload) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.client.delete("/storage/folder/".concat(payload.folderId, "/file/").concat(payload.fileId), this.headers())];
            });
        });
    };
    /**
     * Returns a list of items in trash
     */
    Trash.prototype.getTrash = function () {
        return this.client.get('/storage/trash', this.headers());
    };
    /**
     * Retrieves a paginated list of trashed files or folders.
     * @param {number} limit - The number of items to retrieve per page.
     * @param {number} [offset=0] - The number of items to skip before beginning to return items.
     * @param {'files' | 'folders'} type - The type of content to retrieve.
     * @param {boolean} root - A boolean indicating whether to retrieve content from the root folder.
     * If is not true it has to get a folderId in order to obtain the items or given folderId
     * @param {number} [folderId] - The ID of the folder to retrieve content from.
     * @returns {Promise<FetchTrashContentResponse>} - A promise that resolves with the paginated list of trashed content.
     */
    Trash.prototype.getTrashedFilesPaginated = function (limit, offset, type, root, folderId) {
        if (offset === void 0) { offset = 0; }
        var endpoint = '/storage/trash/paginated';
        var folderIdQuery = folderId !== undefined ? "folderId=".concat(folderId, "&") : '';
        var url = "".concat(endpoint, "?").concat(folderIdQuery, "limit=").concat(limit, "&offset=").concat(offset, "&type=").concat(type, "&root=").concat(root);
        return this.client.get(url, this.headers());
    };
    /**
     * Retrieves a sorted list of trashed files or folders.
     * @param {number} limit - The number of items to retrieve per page.
     * @param {number} [offset=0] - The number of items to skip before beginning to return items.
     * @param {'files' | 'folders'} type - The type of content to retrieve.
     * @param {boolean} root - A boolean indicating whether to retrieve content from the root folder.
     * If is not true it has to get a folderId in order to obtain the items or given folderId
     * @param {'plainName' | 'date'} [sort] - The ID of the folder to retrieve content from.
     * @param {'ASC' | 'DESC'} [order] - The ID of the folder to retrieve content from.
     * @param {number} [folderId] - The ID of the folder to retrieve content from.
     * @returns {Promise<FetchTrashContentResponse>} - A promise that resolves with the paginated list of trashed content.
     */
    Trash.prototype.getTrashedItemsSorted = function (limit, offset, type, root, sort, order, folderId) {
        if (offset === void 0) { offset = 0; }
        var endpoint = '/storage/trash/paginated';
        var folderIdQuery = folderId !== undefined ? "folderId=".concat(folderId, "&") : '';
        var params = "limit=".concat(limit, "&offset=").concat(offset, "&type=").concat(type, "&root=").concat(root, "&sort=").concat(sort, "&order=").concat(order);
        var url = "".concat(endpoint, "?").concat(folderIdQuery).concat(params);
        return this.client.get(url, this.headers());
    };
    /**
     * Add Items to Trash
     * @param payload
     */
    Trash.prototype.addItemsToTrash = function (payload) {
        return this.client.post('/storage/trash/add', {
            items: payload.items,
        }, this.headers());
    };
    /**
     * Removes all items from the trash
     */
    Trash.prototype.clearTrash = function () {
        return this.client.delete('/storage/trash/all', this.headers());
    };
    /**
     * Deletes trashed items permanently
     * @param payload
     */
    Trash.prototype.deleteItemsPermanently = function (payload) {
        return this.client.delete('/storage/trash', this.headers(), {
            items: payload.items,
        });
    };
    /**
     * Deletes trashed items permanently by UUID.
     *
     * @param {DeleteItemsPermanentlyByUUIDPayload} payload - The payload containing the items to be deleted.
     * @return {Promise<void>} A promise that resolves when the items are deleted permanently.
     */
    Trash.prototype.deleteItemsPermanentlyByUUID = function (payload) {
        return this.client.delete('/storage/trash', this.headers(), {
            items: payload.items,
        });
    };
    /**
     * Returns the needed headers for the module requests
     * @private
     */
    Trash.prototype.headers = function () {
        return (0, headers_1.headersWithToken)({
            clientName: this.appDetails.clientName,
            clientVersion: this.appDetails.clientVersion,
            token: this.apiSecurity.token,
            workspaceToken: this.apiSecurity.workspaceToken,
            desktopToken: this.appDetails.desktopHeader,
            customHeaders: this.appDetails.customHeaders,
        });
    };
    return Trash;
}());
exports.Trash = Trash;
